#ifndef __PRIV_HOST_MNG_H__
#define __PRIV_HOST_MNG_H__

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "CRYS_RSA_Types.h"

/*
   *  Object %name    : CC_Functions.h
   *  State           :  %state%
   *  Creation date   :  Aug 4 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief  Secure Boot h file (API and structures )
   *
   *  \version 
   *  \author Danb
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/*------------------------------
    DEFINES
--------------------------------*/
#define DX_CC_MNG_EXT_PUBLIC_KEY_1_INDEX            1
#define DX_CC_MNG_EXT_PUBLIC_KEY_2_INDEX            2
#define DX_CC_MNG_EXT_PUBLIC_KEY_3_INDEX            3
#define DX_CC_MNG_EXT_PUBLIC_KEY_4_INDEX            4



/*-------------------------------
  STRUCTURES
---------------------------------*/


/*------------------------------------------------
    FUNCTIONS
--------------------------------------------------*/


/*
*   @brief The function calculates the HASH of the extended RSA public key , the ECC value of the HASH result and burns the HASH & ECC to the OTP.
*         This function may be called only on the chip manufacture or device manufacture life states.
*         The functions execution steps:
*         1.	calculate HASH - SHA2 - 256 on { E || N }
*         2.	calculate ECC of the SHA2-256 digest.
*         3.	burn the SHA256 digest and the ECC to the OTP
*
*   @param[in] KeyIndex[in]  - the extended key Index (1 - 4 ).
*   @param[in] Keysize[in]  - the key length.
*   @param[in] N_ptr[in] - the modulus vector.
*   @param[in] E[in]- The public exponent.
*
*   Returns:  Status of the operation.
*/
DxError_t DX_CC_MNG_SetExtRsaPubKeysHashOtp(
                             DxUint32_t    keyIndex, 
                             DxUint32_t    keySize, 
                             DxUint8_t     *N_ptr,
                             DxUint32_t    E);
                             



#endif


